<?php

namespace Merchant\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ContractRescissionComposition extends Model 
{

    protected $table = 'contract_rescission_composition';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('rescision_id', 'code', 'title', 'value', 'type');
    protected $visible = array('rescision_id', 'code', 'title', 'value', 'type');

    public function rescision()
    {
        return $this->belongsTo('ContractRescission', 'rescision_id', 'id');
    }

}